/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LoxodonPeacekeeperEffect
extends OneShotEffect {
    LoxodonPeacekeeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "the player with the lowest life total gains control of {this}. If two or more players are tied for lowest life total, you choose one of them, and that player gains control of {this}";
    }

    private LoxodonPeacekeeperEffect(LoxodonPeacekeeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public LoxodonPeacekeeperEffect copy() {
        return new LoxodonPeacekeeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
            Object player;
            int lowLife = Integer.MAX_VALUE;
            HashSet<UUID> tiedPlayers = new HashSet<UUID>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null || player.getLife() >= lowLife) continue;
                lowLife = player.getLife();
            }
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null || player.getLife() != lowLife) continue;
                tiedPlayers.add(playerId);
            }
            if (!tiedPlayers.isEmpty()) {
                UUID newControllerId = null;
                if (tiedPlayers.size() > 1) {
                    FilterPlayer filter = new FilterPlayer("a player tied for lowest life total");
                    for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                        if (tiedPlayers.contains(playerId)) continue;
                        filter.add(Predicates.not((Predicate)new PlayerIdPredicate(playerId)));
                    }
                    TargetPlayer target = new TargetPlayer(1, 1, true, filter);
                    if (target.canChoose(controller.getId(), source, game)) {
                        while (!target.isChosen(game) && target.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                            controller.chooseTarget(this.outcome, (Target)target, source, game);
                        }
                    } else {
                        return false;
                    }
                    newControllerId = game.getPlayer(target.getFirstTarget()).getId();
                } else {
                    for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                        if (!tiedPlayers.contains(playerId)) continue;
                        newControllerId = playerId;
                        break;
                    }
                }
                if (newControllerId != null) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, newControllerId);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                    game.informPlayers(game.getPlayer(newControllerId).getLogName() + " has gained control of " + sourcePermanent.getLogName());
                    return true;
                }
            }
        }
        return false;
    }
}

