/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LukkaCoppercoatOutcastDamageEffect
extends OneShotEffect {
    LukkaCoppercoatOutcastDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each creature you control deals damage equal to its power to each opponent.";
    }

    private LukkaCoppercoatOutcastDamageEffect(LukkaCoppercoatOutcastDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public LukkaCoppercoatOutcastDamageEffect copy() {
        return new LukkaCoppercoatOutcastDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List controlledCreatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        List opponentList = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Permanent permanent : controlledCreatures) {
            for (Player opponent : opponentList) {
                opponent.damage(permanent.getPower().getValue(), permanent.getId(), source, game);
            }
        }
        return true;
    }
}

