/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.CastSpellLastTurnWatcher;

class LureOfPreyRestrictionEffect
extends ContinuousRuleModifyingEffectImpl {
    LureOfPreyRestrictionEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "Cast this spell only if an opponent cast a creature spell this turn";
    }

    private LureOfPreyRestrictionEffect(LureOfPreyRestrictionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(source.getSourceId())) {
            CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
            if (watcher != null) {
                for (UUID playerId : game.getOpponents(source.getControllerId())) {
                    if (watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(playerId) == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public LureOfPreyRestrictionEffect copy() {
        return new LureOfPreyRestrictionEffect(this);
    }
}

