/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class LychguardEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    LychguardEffect() {
        super(Outcome.Benefit);
        this.staticText = "return all legendary creature cards from your graveyard to your hand";
    }

    private LychguardEffect(LychguardEffect effect) {
        super((OneShotEffect)effect);
    }

    public LychguardEffect copy() {
        return new LychguardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards(filter, game));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
    }
}

