/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ReturnLoyalCatharEffect
extends OneShotEffect {
    ReturnLoyalCatharEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield transformed under your control";
    }

    private ReturnLoyalCatharEffect(ReturnLoyalCatharEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnLoyalCatharEffect copy() {
        return new ReturnLoyalCatharEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            game.getState().setValue("EnterTransformed" + card.getId(), (Object)Boolean.TRUE);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

