/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MaarikaBrutalGladiatorEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent("noncreature, nonland permanent");

    MaarikaBrutalGladiatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "if that creature was dealt excess damage this turn, that creature's controller sacrifices a noncreature, nonland permanent";
    }

    private MaarikaBrutalGladiatorEffect(MaarikaBrutalGladiatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaarikaBrutalGladiatorEffect copy() {
        return new MaarikaBrutalGladiatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return false;
        }
        return new SacrificeEffect(filter, 1, "").setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId(), game)).apply(game, source);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

