/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.RandomUtil;

class MaddeningHexEffect
extends OneShotEffect {
    MaddeningHexEffect() {
        super(Outcome.Benefit);
    }

    private MaddeningHexEffect(MaddeningHexEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaddeningHexEffect copy() {
        return new MaddeningHexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int result = controller.rollDice(this.outcome, source, game, 6);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            player.damage(result, source.getSourceId(), source, game);
        }
        if ((permanent = source.getSourcePermanentIfItStillExists(game)) == null) {
            return true;
        }
        Set opponents = game.getOpponents(source.getControllerId(), true);
        if (player != null) {
            opponents.remove(player.getId());
        }
        if (opponents.isEmpty()) {
            return true;
        }
        if (player != null) {
            player.removeAttachment(permanent, source, game);
        }
        if ((opponent = game.getPlayer((UUID)RandomUtil.randomFromCollection((Collection)opponents))) == null) {
            return true;
        }
        opponent.addAttachment(permanent.getId(), source, game);
        game.informPlayers(permanent.getLogName() + " is now attached to " + opponent.getLogName() + ".");
        return true;
    }
}

