/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MaddeningHexEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MaddeningHexTriggeredAbility
extends TriggeredAbilityImpl {
    public MaddeningHexTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MaddeningHexEffect());
    }

    private MaddeningHexTriggeredAbility(MaddeningHexTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (spell == null || permanent == null || spell.isCreature(game) || !event.getPlayerId().equals(permanent.getAttachedTo())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }

    public MaddeningHexTriggeredAbility copy() {
        return new MaddeningHexTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever enchanted player casts a noncreature spell, roll a d6. {this} deals damage to that player equal to the result. Then attach {this} to another one of your opponents chosen at random.";
    }
}

