/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CascadeAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.watchers.common.FirstSpellCastThisTurnWatcher;

class MaelstromNexusGainCascadeFirstSpellEffect
extends ContinuousEffectImpl {
    private final Ability cascadeAbility = new CascadeAbility();

    public MaelstromNexusGainCascadeFirstSpellEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "The first spell you cast each turn has cascade";
    }

    private MaelstromNexusGainCascadeFirstSpellEffect(MaelstromNexusGainCascadeFirstSpellEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MaelstromNexusGainCascadeFirstSpellEffect copy() {
        return new MaelstromNexusGainCascadeFirstSpellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (StackObject stackObject : game.getStack()) {
                if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId())) continue;
                Spell spell = (Spell)stackObject;
                FirstSpellCastThisTurnWatcher watcher = (FirstSpellCastThisTurnWatcher)game.getState().getWatcher(FirstSpellCastThisTurnWatcher.class);
                if (watcher == null || !spell.getId().equals(watcher.getIdOfFirstCastSpell(source.getControllerId()))) continue;
                game.getState().addOtherAbility(spell.getCard(), this.cascadeAbility);
            }
            return true;
        }
        return false;
    }
}

