/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.counters.Counters;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

enum MaesterSeymourValue implements DynamicValue
{
    instance;

    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, sourceAbility.getControllerId(), sourceAbility, game).stream().map(permanent -> permanent.getCounters(game)).mapToInt(Counters::getTotalCount).sum();
    }

    public MaesterSeymourValue copy() {
        return this;
    }

    public String getMessage() {
        return "the number of counters among creatures you control";
    }

    public String toString() {
        return "X";
    }

    static {
        hint = new ValueHint("The number of counters among creatures you control", (DynamicValue)instance);
    }
}

