/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.m.MaestrosAscendancyWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class MaestrosAscendancyCastEffect
extends AsThoughEffectImpl {
    MaestrosAscendancyCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "once during each of your turns, you may cast an instant or sorcery spell from your graveyard by sacrificing a creature in addition to paying its other costs.";
    }

    private MaestrosAscendancyCastEffect(MaestrosAscendancyCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public MaestrosAscendancyCastEffect copy() {
        return new MaestrosAscendancyCastEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || !game.isActivePlayer(affectedControllerId)) {
            return false;
        }
        Card card = game.getCard(objectId);
        Player player = game.getPlayer(affectedControllerId);
        if (card == null || player == null || !card.isOwnedBy(affectedControllerId) || !card.isInstantOrSorcery(game) || !game.getState().getZone(objectId).match(Zone.GRAVEYARD) || MaestrosAscendancyWatcher.checkPlayer(source, game)) {
            return false;
        }
        CostsImpl newCosts = new CostsImpl();
        newCosts.addAll((Collection)card.getSpellAbility().getCosts());
        newCosts.add((Object)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE));
        player.setCastSourceIdWithAlternateMana(card.getId(), card.getManaCost(), (Costs)newCosts, MageIdentifier.MaestrosAscendencyAlternateCast);
        return true;
    }
}

