/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.SpellsCastWatcher;

class MagebaneLizardEffect
extends OneShotEffect {
    MagebaneLizardEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to that player equal to the number of noncreature spells they've cast this turn";
    }

    private MagebaneLizardEffect(MagebaneLizardEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagebaneLizardEffect copy() {
        return new MagebaneLizardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int count = ((SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)).getSpellsCastThisTurn(player.getId()).stream().mapToInt(spell -> !spell.isCreature(game) ? 1 : 0).sum();
        return player.damage(count, source, game) > 0;
    }
}

