/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;

class MagisterOfWorthEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    MagisterOfWorthEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for grace or condemnation. If grace gets more votes, each player returns each creature card from their graveyard to the battlefield. If condemnation gets more votes or the vote is tied, destroy all creatures other than {this}.";
    }

    private MagisterOfWorthEffect(MagisterOfWorthEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagisterOfWorthEffect copy() {
        return new MagisterOfWorthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Grace (return from graveyard)", "Condemnation (destroy all)", Outcome.Benefit);
        vote.doVotes(source, game);
        int graceCount = vote.getVoteCount((Object)true);
        int condemnationCount = vote.getVoteCount((Object)false);
        if (condemnationCount >= graceCount) {
            return new DestroyAllEffect(filter).apply(game, source);
        }
        CardsImpl cards = new CardsImpl();
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.getCards(game)).flatMap(Collection::stream).filter(Objects::nonNull).filter(card -> card.isCreature(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return controller.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

