/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.RepairAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class MaintenanceHangarEffect
extends ContinuousEffectImpl {
    private static final FilterCreatureCard filterCard = new FilterCreatureCard("Starship creatures");

    public MaintenanceHangarEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "and starship creatures in your graveyard have Repair 6";
    }

    private MaintenanceHangarEffect(MaintenanceHangarEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MaintenanceHangarEffect copy() {
        return new MaintenanceHangarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Set cards = controller.getGraveyard().getCards((FilterCard)filterCard, game);
            cards.stream().forEach(card -> game.getState().addOtherAbility(card, (Ability)new RepairAbility(6)));
            return true;
        }
        return false;
    }

    static {
        filterCard.add((Predicate)SubType.STARSHIP.getPredicate());
    }
}

