/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class MairsilThePretenderExileEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    MairsilThePretenderExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile an artifact or creature card from your hand or graveyard and put a cage counter on it.";
    }

    private MairsilThePretenderExileEffect(MairsilThePretenderExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public MairsilThePretenderExileEffect copy() {
        return new MairsilThePretenderExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInHand target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.chooseUse(Outcome.Detriment, "Exile a card from your hand? (No = from graveyard)", source, game)) {
            target = new TargetCardInHand(0, 1, filter);
            controller.choose(this.outcome, (Target)target, source, game);
        } else {
            target = new TargetCardInYourGraveyard(0, 1, filter);
            target.choose(this.outcome, source.getControllerId(), source.getSourceId(), source, game);
        }
        Card card = controller.getHand().get(target.getFirstTarget(), game);
        if (card != null) {
            return CardUtil.moveCardWithCounter((Game)game, (Ability)source, (Player)controller, (Card)card, (Zone)Zone.EXILED, (Counter)CounterType.CAGE.createInstance());
        }
        card = controller.getGraveyard().get(target.getFirstTarget(), game);
        if (card != null) {
            return CardUtil.moveCardWithCounter((Game)game, (Ability)source, (Player)controller, (Card)card, (Zone)Zone.EXILED, (Counter)CounterType.CAGE.createInstance());
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

