/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MajesticMetamorphosisEffect
extends ContinuousEffectImpl {
    MajesticMetamorphosisEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, target artifact or creature becomes a 4/4 Angel artifact creature and gains flying";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private MajesticMetamorphosisEffect(MajesticMetamorphosisEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MajesticMetamorphosisEffect copy() {
        return new MajesticMetamorphosisEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT, CardType.CREATURE});
                permanent.removeAllSubTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.ANGEL});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(4);
                permanent.getToughness().setModifiedBaseValue(4);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

