/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;

class MajesticMyriarchEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filterFirstStrike = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterFlying = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterDeathtouch = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterDoubleStrike = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterHaste = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterHexproof = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterIndestructible = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterLifelink = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterMenace = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterReach = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterTrample = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterVigilance = new FilterControlledCreaturePermanent();

    MajesticMyriarchEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "if you control a creature with flying, {this} gains flying until end of turn. The same is true for first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, reach, trample, and vigilance.";
    }

    private MajesticMyriarchEffect(MajesticMyriarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public MajesticMyriarchEffect copy() {
        return new MajesticMyriarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getBattlefield().containsControlled((FilterPermanent)filterFlying, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterFirstStrike, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterDoubleStrike, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterDeathtouch, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterHaste, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterHexproof, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)HexproofAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterIndestructible, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterLifelink, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterMenace, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new MenaceAbility(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterReach, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)ReachAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterTrample, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterVigilance, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn), source);
        }
        return true;
    }

    static {
        filterFirstStrike.add((Predicate)new AbilityPredicate(FirstStrikeAbility.class));
        filterFlying.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        filterDeathtouch.add((Predicate)new AbilityPredicate(DeathtouchAbility.class));
        filterDoubleStrike.add((Predicate)new AbilityPredicate(DoubleStrikeAbility.class));
        filterHaste.add((Predicate)new AbilityPredicate(HasteAbility.class));
        filterHexproof.add((Predicate)new AbilityPredicate(HexproofBaseAbility.class));
        filterIndestructible.add((Predicate)new AbilityPredicate(IndestructibleAbility.class));
        filterLifelink.add((Predicate)new AbilityPredicate(LifelinkAbility.class));
        filterMenace.add((Predicate)new AbilityPredicate(MenaceAbility.class));
        filterReach.add((Predicate)new AbilityPredicate(ReachAbility.class));
        filterTrample.add((Predicate)new AbilityPredicate(TrampleAbility.class));
        filterVigilance.add((Predicate)new AbilityPredicate(VigilanceAbility.class));
    }
}

