/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MalboroEffect
extends OneShotEffect {
    MalboroEffect() {
        super(Outcome.Benefit);
        this.staticText = ", and exiles the top three cards of their library";
    }

    private MalboroEffect(MalboroEffect effect) {
        super((OneShotEffect)effect);
    }

    public MalboroEffect copy() {
        return new MalboroEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(opponentId);
            if (player == null) continue;
            player.moveCards(player.getLibrary().getTopCards(game, 3), Zone.EXILED, source, game);
        }
        return true;
    }
}

