/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MalcolmAlluringScoundrelEffect
extends OneShotEffect {
    MalcolmAlluringScoundrelEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw a card, then discard a card. If there are four or more chorus counters on {this}, you may cast the discarded card without paying its mana cost.";
    }

    private MalcolmAlluringScoundrelEffect(MalcolmAlluringScoundrelEffect effect) {
        super((OneShotEffect)effect);
    }

    public MalcolmAlluringScoundrelEffect copy() {
        return new MalcolmAlluringScoundrelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        Cards cards = controller.discard(1, false, false, source, game);
        Permanent malcolm = source.getSourcePermanentOrLKI(game);
        if (!cards.isEmpty() && malcolm != null && malcolm.getCounters(game).getCount(CounterType.CHORUS) >= 4) {
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        }
        return true;
    }
}

