/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

class MalcolmKeenEyedNavigatorTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    MalcolmKeenEyedNavigatorTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private MalcolmKeenEyedNavigatorTriggeredAbility(MalcolmKeenEyedNavigatorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PLAYERS;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.PIRATE, game);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        HashSet opponents = new HashSet();
        this.getFilteredEvents((BatchEvent)((DamagedBatchForPlayersEvent)event), game).stream().map(GameEvent::getTargetId).forEach(opponents::add);
        if (opponents.isEmpty()) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new CreateTokenEffect((Token)new TreasureToken(), opponents.size()));
        return true;
    }

    public MalcolmKeenEyedNavigatorTriggeredAbility copy() {
        return new MalcolmKeenEyedNavigatorTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more Pirates you control deal damage to your opponents, you create a Treasure token for each opponent dealt damage.";
    }
}

