/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ManaBreachEffect
extends OneShotEffect {
    ManaBreachEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player returns a land they control to its owner's hand";
    }

    private ManaBreachEffect(ManaBreachEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaBreachEffect copy() {
        return new ManaBreachEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, player.getId(), source, game) < 1) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        return player.moveCards((Card)game.getPermanent(target.getFirstTarget()), Zone.HAND, source, game);
    }
}

