/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ManaCryptEffect
extends OneShotEffect {
    ManaCryptEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you lose the flip, {this} deals 3 damage to you";
    }

    private ManaCryptEffect(ManaCryptEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            if (!player.flipCoin(source, game, true)) {
                player.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public ManaCryptEffect copy() {
        return new ManaCryptEffect(this);
    }
}

