/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ManaEchoesEffect
extends OneShotEffect {
    ManaEchoesEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may add X mana of {C}, where X is the number of creatures you control that share a creature type with it";
    }

    private ManaEchoesEffect(ManaEchoesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaEchoesEffect copy() {
        return new ManaEchoesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && permanent != null) {
            int foundCreatures = 0;
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                if (!permanent.shareCreatureTypes(game, (MageObject)perm)) continue;
                ++foundCreatures;
            }
            if (foundCreatures > 0) {
                controller.getManaPool().addMana(Mana.ColorlessMana((int)foundCreatures), game, source);
            }
            return true;
        }
        return false;
    }
}

