/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ManaSeismEffect
extends OneShotEffect {
    ManaSeismEffect() {
        super(Outcome.Neutral);
        this.staticText = "Sacrifice any number of lands, then add that much {C}";
    }

    private ManaSeismEffect(ManaSeismEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaSeismEffect copy() {
        return new ManaSeismEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = 0;
        TargetSacrifice sacrificeLand = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_LAND);
        if (player.choose(Outcome.Sacrifice, (Target)sacrificeLand, source, game)) {
            for (UUID uuid : sacrificeLand.getTargets()) {
                Permanent land = game.getPermanent(uuid);
                if (land == null) continue;
                land.sacrifice(source, game);
                ++amount;
            }
        }
        player.getManaPool().addMana(Mana.ColorlessMana((int)amount), game, source);
        return true;
    }
}

