/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.ManaWebeffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class ManaWebTriggeredAbility
extends TriggeredAbilityImpl {
    private static final String staticText = "Whenever a land an opponent controls is tapped for mana, tap all lands that player controls that could produce any type of mana that land could produce.";

    ManaWebTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ManaWebeffect(), false);
    }

    private ManaWebTriggeredAbility(ManaWebTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        if (permanent == null || !permanent.isLand(game) || !game.getOpponents(permanent.getControllerId()).contains(this.getControllerId())) {
            return false;
        }
        this.getEffects().setValue("tappedPermanent", (Object)permanent);
        return true;
    }

    public ManaWebTriggeredAbility copy() {
        return new ManaWebTriggeredAbility(this);
    }

    public String getRule() {
        return staticText;
    }
}

