/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ManabondEffect
extends OneShotEffect {
    ManabondEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "reveal your hand and put all land cards from it onto the battlefield. If you do, discard your hand";
    }

    private ManabondEffect(ManabondEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            controller.revealCards(sourceObject.getIdName(), controller.getHand(), game);
            LinkedHashSet<Card> toBattlefield = new LinkedHashSet<Card>();
            for (UUID uuid : controller.getHand()) {
                Card card = game.getCard(uuid);
                if (card == null || !card.isLand(game)) continue;
                toBattlefield.add(card);
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            controller.discard(controller.getHand().size(), false, false, source, game);
            return true;
        }
        return false;
    }

    public ManabondEffect copy() {
        return new ManabondEffect(this);
    }
}

