/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MandateOfAbaddonEffect
extends OneShotEffect {
    MandateOfAbaddonEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature you control. Destroy all creatures with power less than that creature's power";
    }

    private MandateOfAbaddonEffect(MandateOfAbaddonEffect effect) {
        super((OneShotEffect)effect);
    }

    public MandateOfAbaddonEffect copy() {
        return new MandateOfAbaddonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        int power = creature.getPower().getValue();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.getPower().getValue() >= power) continue;
            permanent.destroy(source, game);
        }
        return true;
    }
}

