/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ManifoldInsightsEffect
extends OneShotEffect {
    ManifoldInsightsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top ten cards of your library. Starting with the next opponent in turn order, each opponent chooses a different nonland card from among them. Put the chosen cards into your hand and the rest on the bottom of your library in a random order";
    }

    private ManifoldInsightsEffect(ManifoldInsightsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManifoldInsightsEffect copy() {
        return new ManifoldInsightsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl topLib = new CardsImpl();
            topLib.addAllCards((Collection)controller.getLibrary().getTopCards(game, 10));
            controller.revealCards(sourceObject.getIdName(), (Cards)topLib, game);
            CardsImpl chosenCards = new CardsImpl();
            if (game.getOpponents(controller.getId()).size() >= topLib.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game).size()) {
                chosenCards.addAllCards((Collection)topLib.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game));
                topLib.removeAll((Collection)chosenCards);
            } else if (!topLib.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game).isEmpty()) {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Card card;
                    TargetCard target;
                    Player opponent;
                    if (!controller.hasOpponent(playerId, game) || (opponent = game.getPlayer(playerId)) == null || topLib.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game).isEmpty() || !opponent.choose(Outcome.Detriment, (Cards)topLib, target = new TargetCard(Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND), source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
                    topLib.remove(card);
                    chosenCards.add(card);
                }
            }
            controller.moveCards((Cards)chosenCards, Zone.HAND, source, game);
            controller.putCardsOnBottomOfLibrary((Cards)topLib, game, source, false);
            return true;
        }
        return false;
    }
}

