/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ManipulateFateEffect
extends SearchEffect {
    ManipulateFateEffect() {
        super(new TargetCardInLibrary(3, StaticFilters.FILTER_CARD), Outcome.Benefit);
        this.staticText = "Search your library for three cards, exile them, then shuffle.<br>Draw a card";
    }

    private ManipulateFateEffect(ManipulateFateEffect effect) {
        super((SearchEffect)effect);
    }

    public ManipulateFateEffect copy() {
        return new ManipulateFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.searchLibrary(this.target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)this.target.getTargets()), Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        player.drawCards(1, source, game);
        return true;
    }
}

