/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MantleOfTheAncientsEffect
extends OneShotEffect {
    MantleOfTheAncientsEffect() {
        super(Outcome.Benefit);
        this.staticText = "return any number of target Aura and/or Equipment cards from your graveyard to the battlefield attached to enchanted creature";
    }

    private MantleOfTheAncientsEffect(MantleOfTheAncientsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MantleOfTheAncientsEffect copy() {
        return new MantleOfTheAncientsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (player == null || sourcePermanent == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(sourcePermanent.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        Set<Card> cards = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).filter(card -> !permanent.cantBeAttachedBy((MageObject)card, source, game, true)).collect(Collectors.toSet());
        if (cards.isEmpty()) {
            return false;
        }
        cards.forEach(card -> {
            Permanent cfr_ignored_0 = (Permanent)game.getState().setValue("attachTo:" + card.getId(), (Object)permanent);
        });
        player.moveCards(cards, Zone.BATTLEFIELD, source, game);
        CardsImpl movedCards = new CardsImpl(cards);
        movedCards.retainZone(Zone.BATTLEFIELD, game);
        movedCards.forEach(card -> permanent.addAttachment(card, source, game));
        return true;
    }
}

