/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;

class MarangRiverProwlerCastEffect
extends AsThoughEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a black or green permanent");

    MarangRiverProwlerCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard as long as you control a black or green permanent";
    }

    private MarangRiverProwlerCastEffect(MarangRiverProwlerCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public MarangRiverProwlerCastEffect copy() {
        return new MarangRiverProwlerCastEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        return sourceId.equals(source.getSourceId()) && (card = game.getCard(source.getSourceId())) != null && card.isOwnedBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) > 0;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.BLACK), (Predicate)new ColorPredicate(ObjectColor.GREEN)));
    }
}

