/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MarchOfProgressOverloadEffect
extends OneShotEffect {
    MarchOfProgressOverloadEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose each artifact creature you control. For each creature chosen this way, create a token that's a copy of it";
    }

    private MarchOfProgressOverloadEffect(MarchOfProgressOverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarchOfProgressOverloadEffect copy() {
        return new MarchOfProgressOverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("each artifact creature you control");
            filter.add((Predicate)CardType.ARTIFACT.getPredicate());
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
                if (permanent == null) continue;
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

