/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SpiritWhiteToken;

class MarchOfSoulsEffect
extends OneShotEffect {
    MarchOfSoulsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy all creatures. They can't be regenerated. For each creature destroyed this way, its controller creates a 1/1 white Spirit creature token with flying.";
    }

    private MarchOfSoulsEffect(MarchOfSoulsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarchOfSoulsEffect copy() {
        return new MarchOfSoulsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> playersWithCreatures = new HashMap<UUID, Integer>();
        for (Permanent p : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
            UUID controllerId = p.getControllerId();
            if (!p.destroy(source, game, true)) continue;
            playersWithCreatures.put(controllerId, playersWithCreatures.getOrDefault(controllerId, 0) + 1);
        }
        game.processAction();
        SpiritWhiteToken token = new SpiritWhiteToken();
        for (Map.Entry destroyedCreaturePerPlayer : playersWithCreatures.entrySet()) {
            token.putOntoBattlefield(((Integer)destroyedCreaturePerPlayer.getValue()).intValue(), game, source, (UUID)destroyedCreaturePerPlayer.getKey());
        }
        return true;
    }
}

