/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class MarchesaResoluteMonarchWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    MarchesaResoluteMonarchWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PLAYER: {
                if (((DamagedEvent)event).isCombatDamage()) {
                    this.players.add(event.getTargetId());
                }
                return;
            }
            case END_TURN_STEP_POST: {
                this.players.remove(game.getActivePlayerId());
                return;
            }
        }
    }

    static boolean checkPlayer(Game game, Ability source) {
        return !((MarchesaResoluteMonarchWatcher)game.getState().getWatcher(MarchesaResoluteMonarchWatcher.class)).players.contains(source.getControllerId());
    }
}

