/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MarcusMutantMayorEffect
extends OneShotEffect {
    MarcusMutantMayorEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if that creature has a +1/+1 counter on it. If it doesn't, put a +1/+1 counter on it.";
    }

    private MarcusMutantMayorEffect(MarcusMutantMayorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        DrawCardSourceControllerEffect effect = permanent.getCounters(game).getCount(CounterType.P1P1) >= 1 ? new DrawCardSourceControllerEffect(1) : new AddCountersTargetEffect(CounterType.P1P1.createInstance()).setTargetPointer(this.getTargetPointer().copy());
        return effect.apply(game, source);
    }

    public MarcusMutantMayorEffect copy() {
        return new MarcusMutantMayorEffect(this);
    }
}

