/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;
import mage.util.functions.CopyTokenFunction;

class MarduSiegebreakerEffect
extends OneShotEffect {
    MarduSiegebreakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, create a tapped token that's a copy of the exiled card attacking that opponent. At the beginning of your next end step, sacrifice those tokens";
    }

    private MarduSiegebreakerEffect(MarduSiegebreakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarduSiegebreakerEffect copy() {
        return new MarduSiegebreakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        ExileZone cards = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (cards == null) {
            return false;
        }
        switch (cards.size()) {
            case 0: {
                return false;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                card = Optional.ofNullable(game.getPlayer(source.getControllerId())).map(arg_0 -> MarduSiegebreakerEffect.lambda$apply$0((Cards)cards, source, game, arg_0)).orElse(null);
            }
        }
        if (card == null) {
            return false;
        }
        HashSet addedTokens = new HashSet();
        Token token = CopyTokenFunction.createTokenCopy((Card)card, (Game)game);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            token.putOntoBattlefield(1, game, source, source.getControllerId(), true, true, opponentId);
            token.getLastAddedTokenIds().stream().map(uuid -> new MageObjectReference(uuid, game)).forEach(addedTokens::add);
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(addedTokens)), TargetController.YOU), source);
        return true;
    }

    private static /* synthetic */ Card lambda$apply$0(Cards cards, Ability source, Game game, Player player) {
        TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
        target.withNotTarget(true);
        target.withChooseHint("to copy");
        player.choose(Outcome.Neutral, cards, (TargetCard)target, source, game);
        return game.getCard(target.getFirstTarget());
    }
}

