/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MarketGnomeTriggeredAbility
extends TriggeredAbilityImpl {
    MarketGnomeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(1));
        this.addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy("and"));
        this.setTriggerPhrase("When {this} is exiled from the battlefield while you're activating a craft ability, ");
    }

    private MarketGnomeTriggeredAbility(MarketGnomeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MarketGnomeTriggeredAbility copy() {
        return new MarketGnomeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXILED_WHILE_CRAFTING;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
        return permanent != null && sourcePermanent != null && permanent.getId().equals(sourcePermanent.getId());
    }
}

