/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MarshalingTheTroops;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class MarshalingTheTroopsEffect
extends OneShotEffect {
    MarshalingTheTroopsEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Tap any number of untapped creatures you control. You gain 4 life for each creature tapped this way";
    }

    private MarshalingTheTroopsEffect(MarshalingTheTroopsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(0, Integer.MAX_VALUE, MarshalingTheTroops.filter, true);
        controller.choose(this.outcome, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        int tappedAmount = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.tap(source, game)) continue;
            ++tappedAmount;
        }
        if (tappedAmount > 0) {
            controller.gainLife(tappedAmount * 4, game, source);
        }
        return true;
    }

    public MarshalingTheTroopsEffect copy() {
        return new MarshalingTheTroopsEffect(this);
    }
}

