/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.m.MartyrdomActivatedAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MartyrdomGainAbilityTargetEffect
extends ContinuousEffectImpl {
    MartyrdomGainAbilityTargetEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Until end of turn, target creature you control gains \"{0}: The next 1 damage that would be dealt to target creature, planeswalker, or player this turn is dealt to this creature instead.\" Only you may activate this ability";
    }

    private MartyrdomGainAbilityTargetEffect(MartyrdomGainAbilityTargetEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            MartyrdomActivatedAbility ability = new MartyrdomActivatedAbility(source.getControllerId());
            ability.setMayActivate(TargetController.ANY);
            permanent.addAbility((Ability)ability, source.getSourceId(), game);
            return true;
        }
        return false;
    }

    public MartyrdomGainAbilityTargetEffect copy() {
        return new MartyrdomGainAbilityTargetEffect(this);
    }
}

