/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MarvinMurderousMimicEffect
extends ContinuousEffectImpl {
    MarvinMurderousMimicEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of creatures you control that don't have the same name as this creature";
    }

    private MarvinMurderousMimicEffect(MarvinMurderousMimicEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MarvinMurderousMimicEffect copy() {
        return new MarvinMurderousMimicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        List abilities = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(p -> !CardUtil.haveSameNames((MageObject)p, (MageObject)permanent)).map(p -> p.getAbilities(game)).flatMap(Collection::stream).filter(Ability::isActivatedAbility).collect(Collectors.toList());
        for (Ability ability : abilities) {
            permanent.addAbility(ability, source.getSourceId(), game);
        }
        return true;
    }
}

