/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MaskOfGriselbrandEffect
extends OneShotEffect {
    MaskOfGriselbrandEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you may pay X life, where X is its power. If you do, draw X cards";
    }

    private MaskOfGriselbrandEffect(MaskOfGriselbrandEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaskOfGriselbrandEffect copy() {
        return new MaskOfGriselbrandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("attachedTo");
        if (controller == null || permanent == null) {
            return false;
        }
        int xValue = permanent.getPower().getValue();
        PayLifeCost cost = new PayLifeCost(xValue);
        if (cost.canPay(source, source, source.getControllerId(), game) && controller.chooseUse(this.outcome, "Pay " + xValue + " life? If you do, draw " + xValue + " cards.", source, game) && cost.pay(source, game, source, source.getControllerId(), false)) {
            controller.drawCards(xValue, source, game);
        }
        return true;
    }
}

