/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class MassacreGirlDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    MassacreGirlDelayedTriggeredAbility() {
        super((Effect)new BoostAllEffect(-1, -1, Duration.EndOfTurn, true), Duration.EndOfTurn, false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MassacreGirlDelayedTriggeredAbility(MassacreGirlDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget().isCreature(game);
    }

    public MassacreGirlDelayedTriggeredAbility copy() {
        return new MassacreGirlDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature dies this turn, each creature other than {this} gets -1/-1 until end of turn";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

