/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class MastermindPlumEffect
extends OneShotEffect {
    MastermindPlumEffect() {
        super(Outcome.Exile);
        this.staticText = "exile up to one target card from a graveyard. If an artifact card was exiled this way, create a Treasure token.";
    }

    private MastermindPlumEffect(MastermindPlumEffect effect) {
        super((OneShotEffect)effect);
    }

    public MastermindPlumEffect copy() {
        return new MastermindPlumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (cards.isEmpty()) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game) > 0) {
            TreasureToken treasure = new TreasureToken();
            treasure.putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

