/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.AllyToken;

class MatchTheOddsEffect
extends OneShotEffect {
    MatchTheOddsEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 white Ally creature token. Put a +1/+1 counter on it for each creature your opponents control";
    }

    private MatchTheOddsEffect(MatchTheOddsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MatchTheOddsEffect copy() {
        return new MatchTheOddsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        AllyToken token = new AllyToken();
        token.putOntoBattlefield(1, game, source);
        int count = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, source.getControllerId(), source, game);
        if (count < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Optional.ofNullable(tokenId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(count), source, game));
        }
        return true;
    }
}

