/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardAllEffect;
import mage.abilities.effects.common.GainLifeAllEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MathasFiendSeekerEffect
extends ContinuousEffectImpl {
    private final Ability ability;

    MathasFiendSeekerEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "For as long as that creature has a bounty counter on it, it has \"When this creature dies, each opponent draws a card and gains 2 life.\"";
        this.ability = new DiesSourceTriggeredAbility((Effect)new DrawCardAllEffect(1, TargetController.OPPONENT));
        this.ability.addEffect((Effect)new GainLifeAllEffect(2, TargetController.OPPONENT).setText("and gains 2 life"));
    }

    private MathasFiendSeekerEffect(MathasFiendSeekerEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.ability = effect.ability.copy();
    }

    public MathasFiendSeekerEffect copy() {
        return new MathasFiendSeekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null || !creature.getCounters(game).containsKey(CounterType.BOUNTY)) {
            this.discard();
            return false;
        }
        creature.addAbility(this.ability, source.getSourceId(), game);
        return true;
    }
}

