/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class MatterReshaperEffect
extends OneShotEffect {
    MatterReshaperEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. You may put that card onto the battlefield if it's a permanent card with mana value 3 or less. Otherwise, put that card into your hand";
    }

    private MatterReshaperEffect(MatterReshaperEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card == null) {
                return false;
            }
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            FilterPermanentCard filter = new FilterPermanentCard("permanent card with mana value 3 or less");
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
            if (filter.match(card, game) && controller.chooseUse(Outcome.PutCardInPlay, "Put " + card.getName() + " onto the battlefield (otherwise put in hand)?", source, game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                return true;
            }
            controller.moveCards(card, Zone.HAND, source, game);
            return true;
        }
        return false;
    }

    public MatterReshaperEffect copy() {
        return new MatterReshaperEffect(this);
    }
}

