/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.keyword.ShadowAbility;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class MazeOfShadows
extends CardImpl {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature("attacking creature with shadow");

    public MazeOfShadows(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new ColorlessManaAbility());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new UntapTargetEffect(), (Cost)new TapSourceCost());
        PreventDamageByTargetEffect effect = new PreventDamageByTargetEffect(Duration.EndOfTurn, true);
        effect.setText("Prevent all combat damage that would be dealt to");
        ability.addEffect((Effect)effect);
        effect = new PreventDamageToTargetEffect(Duration.EndOfTurn, Integer.MAX_VALUE, true);
        effect.setText("and dealt by that creature this turn");
        ability.addEffect((Effect)effect);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.addAbility((Ability)ability);
    }

    private MazeOfShadows(MazeOfShadows card) {
        super((CardImpl)card);
    }

    public MazeOfShadows copy() {
        return new MazeOfShadows(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(ShadowAbility.class));
    }
}

