/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlashAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.ToxicAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public class MazesMantle
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("enchanted creature has toxic");
    private static final Condition condition;

    public MazesMantle(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{G}");
        this.addSubType(new SubType[]{SubType.AURA});
        this.addAbility((Ability)FlashAbility.getInstance());
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new GainAbilityAttachedEffect((Ability)HexproofAbility.getInstance(), AttachmentType.AURA, Duration.EndOfTurn).setText("that creature gains hexproof until end of turn")).withInterveningIf(condition));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2, Duration.WhileOnBattlefield)));
    }

    private MazesMantle(MazesMantle card) {
        super((CardImpl)card);
    }

    public MazesMantle copy() {
        return new MazesMantle(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(ToxicAbility.class));
        condition = new AttachedToMatchesFilterCondition(filter);
    }
}

