/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.Cards;
import mage.cards.m.MechtitanCoreReturnEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class MechtitanCoreTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<UUID> tokenIds = new HashSet<UUID>();

    MechtitanCoreTriggeredAbility(Token token, Ability source, Game game) {
        super((Effect)new MechtitanCoreReturnEffect(), Duration.Custom, false, false);
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets((Cards)game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source)), game));
        this.tokenIds.addAll(token.getLastAddedTokenIds());
    }

    private MechtitanCoreTriggeredAbility(MechtitanCoreTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.tokenIds.addAll(ability.tokenIds);
    }

    public MechtitanCoreTriggeredAbility copy() {
        return new MechtitanCoreTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.tokenIds.contains(event.getTargetId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            this.tokenIds.remove(event.getTargetId());
            return true;
        }
        return false;
    }

    public boolean isInactive(Game game) {
        return this.tokenIds.isEmpty();
    }

    public String getRule() {
        return "When that token leaves the battlefield, return all cards exiled with {this} except {this} to the battlefield tapped under their owners' control";
    }
}

