/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.Target;

class MeddleEffect
extends OneShotEffect {
    MeddleEffect() {
        super(Outcome.Benefit);
        this.staticText = "If target spell has only one target and that target is a creature, change that spell's target to another creature.";
    }

    private MeddleEffect(MeddleEffect effect) {
        super((OneShotEffect)effect);
    }

    public MeddleEffect copy() {
        return new MeddleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!MeddleEffect.checkTarget(game, source)) {
            return false;
        }
        Spell spell = game.getSpell(source.getFirstTarget());
        spell.chooseNewTargets(game, source.getControllerId(), true, false, null);
        return true;
    }

    private static final boolean checkTarget(Game game, Ability source) {
        StackObject stackObject = game.getState().getStack().getStackObject(source.getFirstTarget());
        if (stackObject == null) {
            return false;
        }
        int numberOfTargets = 0;
        for (UUID modeId : stackObject.getStackAbility().getModes().getSelectedModes()) {
            Mode mode = stackObject.getStackAbility().getModes().get((Object)modeId);
            for (Target target : mode.getTargets()) {
                for (UUID targetId : target.getTargets()) {
                    if (numberOfTargets++ > 1) {
                        return false;
                    }
                    Permanent permanent = game.getPermanent(targetId);
                    if (permanent != null && permanent.isCreature(game)) continue;
                    return false;
                }
            }
        }
        return numberOfTargets == 1;
    }
}

